import 'package:admin_desktop/domain/models/response/booking_count_statistic_response.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/booking/widgets/statistic_percent_widget.dart';
import 'package:flutter/material.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';

class StatisticPage extends StatelessWidget {
  final BookingStatisticResponse? statistic;

  const StatisticPage({super.key, required this.statistic});

  @override
  Widget build(BuildContext context) {
    return Container(
        height: 312,
        padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 30),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(10),
          color: Style.white,
        ),
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Row(
              crossAxisAlignment: CrossAxisAlignment.center,
              mainAxisAlignment: MainAxisAlignment.start,
              children: [
                StatisticPercentWidget(
                  percent: statistic?.newBooked?.percent,
                  status: TrKeys.newKey,
                ),
                StatisticPercentWidget(
                    percent: statistic?.booked?.percent, status: TrKeys.booked),
                StatisticPercentWidget(
                    percent: statistic?.progress?.percent,
                    status: TrKeys.progress),
                StatisticPercentWidget(
                    percent: statistic?.canceled?.percent,
                    status: TrKeys.canceled),
                StatisticPercentWidget(
                    percent: statistic?.ended?.percent, status: TrKeys.ended),
              ],
            ),
            Spacer(),
            Text(
              AppHelpers.getTranslation(TrKeys.everyLarge),
              style: Style.interNormal(size: 14),
            ),
          ],
        ));
  }
}
